/*==========================================================================;
 *
 *  (c) 2007-08 JSI.  All rights reserved.
 *
 *  File:          Pair2.cs
 *  Version:       1.0
 *  Desc:		   Pair data structure (struct)
 *  Author:        Miha Grcar
 *  Created on:    Nov-2007
 *  Last modified: Aug-2008
 *  Revision:      Aug-2008
 *
 ***************************************************************************/

using System;
using System.Collections.Generic;

namespace Latino
{
    /* .-----------------------------------------------------------------------
       |
       |  Struct Pair2<FirstT, SecondT>
       |
       '-----------------------------------------------------------------------
    */
    public struct Pair2<FirstT, SecondT> : IDeeplyCloneable<Pair2<FirstT, SecondT>>, IContentEquatable<Pair2<FirstT, SecondT>>, ISerializable
    {
        private FirstT m_first;
        private SecondT m_second;
        public Pair2(BinarySerializer reader)
        {
            m_first = default(FirstT);
            m_second = default(SecondT);
            Load(reader); // throws ArgumentNullException, serialization-related exceptions
        }
        public Pair2(FirstT first, SecondT second)
        {
            m_first = first;
            m_second = second;
        }
        public FirstT First
        {
            get { return m_first; }
            set { m_first = value; }
        }
        public SecondT Second
        {
            get { return m_second; }
            set { m_second = value; }
        }
        public override string ToString()
        {
            return string.Format("( {0}, {1} )", m_first, m_second);
        }
        public override bool Equals(object obj)
        {
            return base.Equals(obj);
        }
        public override int GetHashCode()
        {
            return base.GetHashCode();
        }
        public static bool operator ==(Pair2<FirstT, SecondT> first, Pair2<FirstT, SecondT> second)
        {
            return first.Equals(second);
        }
        public static bool operator !=(Pair2<FirstT, SecondT> first, Pair2<FirstT, SecondT> second)
        {
            return !first.Equals(second);
        }
        // *** IDeeplyCloneable interface implementation ***
        public Pair2<FirstT, SecondT> DeeplyClone()
        {
            return new Pair2<FirstT, SecondT>((FirstT)Utils.Clone(m_first, /*deep_clone=*/true), (SecondT)Utils.Clone(m_second, /*deep_clone=*/true));
        }
        object IDeeplyCloneable.DeeplyClone()
        {
            return DeeplyClone();
        }
        // *** IContentEquatable<Pair2<FirstT, SecondT>> interface implementation ***
        public bool ContentEquals(Pair2<FirstT, SecondT> other)
        {
            return Utils.ObjectEquals(m_first, other.m_first, /*deep_cmp=*/true) && Utils.ObjectEquals(m_second, other.m_second, /*deep_cmp=*/true);
        }
        bool IContentEquatable.ContentEquals(object other)
        {
            Utils.ThrowException(other == null ? new ArgumentNullException("other") : null);
            Utils.ThrowException(!(other is Pair2<FirstT, SecondT>) ? new ArgumentTypeException("other") : null);
            return ContentEquals((Pair2<FirstT, SecondT>)other);
        }
        // *** ISerializable interface implementation ***
        public void Save(BinarySerializer writer)
        {
            Utils.ThrowException(writer == null ? new ArgumentNullException("writer") : null);
            // the following statements throw serialization-related exceptions
            writer.WriteValueOrObject<FirstT>(m_first); 
            writer.WriteValueOrObject<SecondT>(m_second); 
        }
        public void Load(BinarySerializer reader)
        {
            Utils.ThrowException(reader == null ? new ArgumentNullException("reader") : null);
            // the following statements throw serialization-related exceptions
            m_first = reader.ReadValueOrObject<FirstT>(); 
            m_second = reader.ReadValueOrObject<SecondT>(); 
        }
        // *** Equality comparer ***
        public static IEqualityComparer<Pair2<FirstT, SecondT>> GetEqualityComparer()
        {
            return new GenericEqualityComparer<Pair2<FirstT, SecondT>>();
        }
    }
}
