/*==========================================================================;
 *
 *  (c) 2007-08 JSI.  All rights reserved.
 *
 *  File:          Dataset.cs
 *  Version:       1.0
 *  Desc:		   Datasets for training machine learning models
 *  Author:        Miha Grcar
 *  Created on:    Aug-2007
 *  Last modified: Oct-2008
 *  Revision:      Oct-2008
 *
 ***************************************************************************/

using System;
using System.Collections;
using System.Collections.Generic;
//using Latino.TextGarden;

namespace Latino.Model
{
    /* .-----------------------------------------------------------------------
       |
       |  Interface IExampleCollection<LblT>
       |
       '-----------------------------------------------------------------------
    */
    public interface IExampleCollection<LblT> : IEnumerableList
    {
        Type ExampleType { get; }
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface IExampleCollection<LblT, ExT>
       |
       '-----------------------------------------------------------------------
    */
    public interface IExampleCollection<LblT, ExT> : IExampleCollection<LblT>, IEnumerableList<Pair2<LblT, ExT>>
    {
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface IConvertibleDataset<LblT>
       |
       '-----------------------------------------------------------------------
    */
    public interface IConvertibleDataset<LblT>
    {
        IDataset<LblT> ConvertDataset(Type new_ex_type);
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface IDataset<LblT>
       |
       '-----------------------------------------------------------------------
    */
    public interface IDataset<LblT> : IExampleCollection<LblT>, IConvertibleDataset<LblT>//, ISerializable
    {
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface IDataset<LblT, ExT>
       |
       '-----------------------------------------------------------------------
    */
    public interface IDataset<LblT, ExT> : IDataset<LblT>, IExampleCollection<LblT, ExT>
    {
    }

    /* .-----------------------------------------------------------------------
       |
       |  Class Dataset<LblT>
       |
       '-----------------------------------------------------------------------
    */
    public class Dataset<LblT> : IDataset<LblT, SparseVector2<double>>
    {
        private ArrayList<Pair2<LblT, SparseVector2<double>>> m_items
        = new ArrayList<Pair2<LblT, SparseVector2<double>>>();
        public void Add(LblT label, SparseVector2<double> example)
        {
            Utils.ThrowException(example == null ? new ArgumentNullException("example") : null);
            m_items.Add(new Pair2<LblT, SparseVector2<double>>(label, example));
        }
        public void RemoveAt(int index)
        {
            m_items.RemoveAt(index); // throws ArgumentOutOfRangeException
        }
        public void Clear()
        {
            m_items.Clear();
        }
        // *** IDataset<LblT> interface implementation ***
        public Type ExampleType
        {
            get { return typeof(SparseVector2<double>); }
        }
        // *** IExampleCollection<Pair2<LblT, SparseVector2<double>>> interface implementation ***
        public int Count
        {
            get { return m_items.Count; }
        }
        public Pair2<LblT, SparseVector2<double>> this[int index]
        {
            get
            {
                Utils.ThrowException((index < 0 || index >= m_items.Count) ? new ArgumentOutOfRangeException("index") : null);
                return m_items[index];
            }
        }
        object IEnumerableList.this[int index]
        {
            get { return this[index]; } // throws ArgumentOutOfRangeException
        }
        public IEnumerator<Pair2<LblT, SparseVector2<double>>> GetEnumerator()
        {
            return new ListEnum<Pair2<LblT, SparseVector2<double>>>(this);
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            return new ListEnum(this);
        }
        // *** IConvertibleDataset<LblT> interface implementation ***
        public IDataset<LblT> ConvertDataset(Type new_ex_type)
        {
            Utils.ThrowException(new_ex_type == null ? new ArgumentNullException("new_ex_type") : null);
            /*if (new_ex_type == typeof(BowSpV))
            {
                BowDataset<LblT> new_dataset = new BowDataset<LblT>();
                foreach (Pair2<LblT, SparseVector2<double>> example in m_items)
                {
                    new_dataset.Add(example.First, ModelUtils.ConvertExample<SparseVector2<double>, BowSpV>(example.Second));
                }
                return new_dataset;
            }
            else*/ if (new_ex_type == typeof(SvmFeatureVector))
            {
                SvmDataset<LblT> new_dataset = new SvmDataset<LblT>();
                foreach (Pair2<LblT, SparseVector2<double>> example in m_items)
                {
                    new_dataset.Add(example.First, ModelUtils.ConvertExample<SparseVector2<double>, SvmFeatureVector>(example.Second));
                }
                return (IDataset<LblT>)new_dataset;
            }
            else
            {
                throw new ArgumentNotSupportedException("new_ex_type");
            }
        }
    }

    ///* .-----------------------------------------------------------------------
    //   |
    //   |  Class BowDataset<LblT>
    //   |
    //   '-----------------------------------------------------------------------
    //*/
    //public class BowDataset<LblT> : IDataset<LblT, BowSpV>
    //{
    //    private ArrayList<Pair2<LblT, BowSpV>> m_items
    //        = new ArrayList<Pair2<LblT, BowSpV>>();
    //    public void Add(LblT label, BowSpV example)
    //    {
    //        Utils.ThrowException(example == null ? new ArgumentNullException("example") : null);
    //        m_items.Add(new Pair2<LblT, BowSpV>(label, example));
    //    }
    //    public void RemoveAt(int index)
    //    {
    //        m_items.RemoveAt(index); // throws ArgumentOutOfRangeException
    //    }
    //    public void Clear()
    //    {
    //        m_items.Clear();
    //    }
    //    // *** IDataset<LblT> interface implementation ***
    //    public Type ExampleType
    //    {
    //        get { return typeof(BowSpV); }
    //    }
    //    // *** IExampleCollection<Pair2<LblT, BowSpV>> interface implementation ***
    //    public int Count
    //    {
    //        get { return m_items.Count; }
    //    }
    //    public Pair2<LblT, BowSpV> this[int index]
    //    {
    //        get
    //        {
    //            Utils.ThrowException((index < 0 || index >= m_items.Count) ? new ArgumentOutOfRangeException("index") : null);
    //            return m_items[index];
    //        }
    //    }
    //    object IEnumerableList.this[int index]
    //    {
    //        get { return this[index]; } // throws ArgumentOutOfRangeException
    //    }
    //    public IEnumerator<Pair2<LblT, BowSpV>> GetEnumerator()
    //    {
    //        return new ListEnum<Pair2<LblT, BowSpV>>(this);
    //    }
    //    IEnumerator IEnumerable.GetEnumerator()
    //    {
    //        return new ListEnum(this);
    //    }
    //    // *** IConvertibleDataset<LblT> interface implementation ***
    //    public IDataset<LblT> ConvertDataset(Type new_ex_type)
    //    {
    //        Utils.ThrowException(new_ex_type == null ? new ArgumentNullException("new_ex_type") : null);
    //        if (new_ex_type == typeof(SparseVector2<double>))
    //        {
    //            Dataset<LblT> new_dataset = new Dataset<LblT>();
    //            foreach (Pair2<LblT, BowSpV> example in m_items)
    //            {
    //                new_dataset.Add(example.First, ModelUtils.ConvertExample<BowSpV, SparseVector2<double>>(example.Second));
    //            }
    //            return new_dataset;
    //        }
    //        else if (new_ex_type == typeof(SvmFeatureVector))
    //        {
    //            SvmDataset<LblT> new_dataset = new SvmDataset<LblT>();
    //            foreach (Pair2<LblT, BowSpV> example in m_items)
    //            {
    //                new_dataset.Add(example.First, ModelUtils.ConvertExample<BowSpV, SvmFeatureVector>(example.Second));
    //            }
    //            return new_dataset;
    //        }
    //        else
    //        {
    //            throw new ArgumentNotSupportedException("new_ex_type");
    //        }
    //    }
    //}

    /* .-----------------------------------------------------------------------
       |
       |  Class SvmDataset<LblT>
       |
       '-----------------------------------------------------------------------
    */
    public class SvmDataset<LblT> : IDataset<LblT, SvmFeatureVector>
    {
        private ArrayList<Pair2<LblT, SvmFeatureVector>> m_items
            = new ArrayList<Pair2<LblT, SvmFeatureVector>>();
        public SvmDataset()
        {
        }
        public void Add(LblT label, SvmFeatureVector example)
        {
            Utils.ThrowException(example == null ? new ArgumentNullException("example") : null);
            m_items.Add(new Pair2<LblT, SvmFeatureVector>(label, example));
        }
        public void RemoveAt(int index)
        {
            m_items.RemoveAt(index); // throws ArgumentOutOfRangeException
        }
        public void Clear()
        {
            m_items.Clear();
        }
        // *** IDataset<LblT> interface implementation ***
        public Type ExampleType
        {
            get { return typeof(SvmFeatureVector); }
        }
        // *** IExampleCollection<Pair2<LblT, SvmFeatureVector>> interface implementation ***
        public int Count
        {
            get { return m_items.Count; }
        }
        public Pair2<LblT, SvmFeatureVector> this[int index]
        {
            get
            {
                Utils.ThrowException((index < 0 || index >= m_items.Count) ? new ArgumentOutOfRangeException("index") : null);
                return m_items[index];
            }
        }
        object IEnumerableList.this[int index]
        {
            get { return this[index]; } // throws ArgumentOutOfRangeException
        }
        public IEnumerator<Pair2<LblT, SvmFeatureVector>> GetEnumerator()
        {
            return new ListEnum<Pair2<LblT, SvmFeatureVector>>(this);
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            return new ListEnum(this);
        }
        // *** IConvertibleDataset<LblT> interface implementation ***
        public IDataset<LblT> ConvertDataset(Type new_ex_type)
        {
            Utils.ThrowException(new_ex_type == null ? new ArgumentNullException("new_ex_type") : null);
            if (new_ex_type == typeof(SparseVector2<double>))
            {
                Dataset<LblT> new_dataset = new Dataset<LblT>();
                foreach (Pair2<LblT, SvmFeatureVector> example in m_items)
                {
                    new_dataset.Add(example.First, ModelUtils.ConvertExample<SvmFeatureVector, SparseVector2<double>>(example.Second));
                }
                return new_dataset;
            }
            //else if (new_ex_type == typeof(BowSpV))
            //{
            //    BowDataset<LblT> new_dataset = new BowDataset<LblT>();
            //    foreach (Pair2<LblT, SvmFeatureVector> example in m_items)
            //    {
            //        new_dataset.Add(example.First, ModelUtils.ConvertExample<SvmFeatureVector, BowSpV>(example.Second));
            //    }
            //    return new_dataset;
            //}
            else
            {
                throw new ArgumentNotSupportedException("new_ex_type");
            }
        }
    }
}