/*==========================================================================;
 *
 *  (c) 2007-08 JSI.  All rights reserved.
 *
 *  File:          KeyDat2.cs
 *  Version:       1.0
 *  Desc:		   Dictionary item data structure (struct)
 *  Author:        Miha Grcar
 *  Created on:    Mar-2007
 *  Last modified: Aug-2008
 *  Revision:      Aug-2008
 *
 ***************************************************************************/

using System;

namespace Latino
{
    /* .-----------------------------------------------------------------------
       |
       |  Struct KeyDat2<KeyT, DatT>
       |
       '-----------------------------------------------------------------------
    */
    public struct KeyDat2<KeyT, DatT> : IComparable<KeyDat2<KeyT, DatT>>, IComparable, IEquatable<KeyDat2<KeyT, DatT>>, ISerializable where KeyT : IComparable
    {
        private KeyT m_key;
        private DatT m_dat;
        public KeyDat2(BinarySerializer reader)
        {
            m_key = default(KeyT);
            m_dat = default(DatT);
            Load(reader); // throws ArgumentNullException, serialization-related exceptions
        }
        public KeyDat2(KeyT key, DatT dat)
        {
            Utils.ThrowException(key == null ? new ArgumentNullException("key") : null);
            m_key = key;
            m_dat = dat;
        }
        public KeyDat2(KeyT key)
        {
            Utils.ThrowException(key == null ? new ArgumentNullException("key") : null);
            m_key = key;
            m_dat = default(DatT);
        }
        public KeyT Key
        {
            get { return m_key; }
            set
            {
                Utils.ThrowException(value == null ? new ArgumentNullException("Key setter value") : null);
                m_key = value;
            }
        }
        public DatT Dat
        {
            get { return m_dat; }
            set { m_dat = value; }
        }
        public override int GetHashCode()
        {
            return m_key.GetHashCode();
        }
        public override string ToString()
        {
            return string.Format("( {0} {1} )", m_key, m_dat);
        }
        public static bool operator ==(KeyDat2<KeyT, DatT> a, KeyDat2<KeyT, DatT> b)
        {
            return a.m_key.CompareTo(b.m_key) == 0;
        }
        public static bool operator !=(KeyDat2<KeyT, DatT> a, KeyDat2<KeyT, DatT> b)
        {
            return a.m_key.CompareTo(b.m_key) != 0;
        }
        public static bool operator >(KeyDat2<KeyT, DatT> a, KeyDat2<KeyT, DatT> b)
        {
            return a.m_key.CompareTo(b.m_key) > 0;
        }
        public static bool operator <(KeyDat2<KeyT, DatT> a, KeyDat2<KeyT, DatT> b)
        {
            return a.m_key.CompareTo(b.m_key) < 0;
        }
        public static bool operator >=(KeyDat2<KeyT, DatT> a, KeyDat2<KeyT, DatT> b)
        {
            return a.m_key.CompareTo(b.m_key) >= 0;
        }
        public static bool operator <=(KeyDat2<KeyT, DatT> a, KeyDat2<KeyT, DatT> b)
        {
            return a.m_key.CompareTo(b.m_key) <= 0;
        }
        // *** IComparable<KeyDat2<KeyT, DatT>> interface implementation ***
        public int CompareTo(KeyDat2<KeyT, DatT> other)
        {
            return m_key.CompareTo(other.Key);
        }
        // *** IComparable interface implementation ***
        int IComparable.CompareTo(object obj)
        {
            Utils.ThrowException(!(obj is KeyDat2<KeyT, DatT>) ? new ArgumentTypeException("obj") : null);
            return CompareTo((KeyDat2<KeyT, DatT>)obj);
        }
        // *** IEquatable<KeyDat2<KeyT, DatT>> interface implementation ***
        public bool Equals(KeyDat2<KeyT, DatT> other)
        {
            return other.m_key.Equals(m_key);
        }
        public override bool Equals(object obj)
        {
            Utils.ThrowException(!(obj is KeyDat2<KeyT, DatT>) ? new ArgumentTypeException("obj") : null);
            return Equals((KeyDat2<KeyT, DatT>)obj);
        }
        // *** ISerializable interface implementation ***
        public void Save(BinarySerializer writer)
        {
            Utils.ThrowException(writer == null ? new ArgumentNullException("writer") : null);
            // the following statements throw serialization-related exceptions
            writer.WriteValueOrObject<KeyT>(m_key); 
            writer.WriteValueOrObject<DatT>(m_dat);
        }
        public void Load(BinarySerializer reader)
        {
            Utils.ThrowException(reader == null ? new ArgumentNullException("reader") : null);
            // the following statements throw serialization-related exceptions
            m_key = reader.ReadValueOrObject<KeyT>(); 
            m_dat = reader.ReadValueOrObject<DatT>(); 
        }
    }
}
