/*==========================================================================;
 *
 *  (c) 2007-08 JSI.  All rights reserved.
 *
 *  File:          Interfaces.cs
 *  Version:       1.0
 *  Desc:		   Additional interfaces
 *  Author:        Miha Grcar
 *  Created on:    Nov-2007
 *  Last modified: May-2008
 *  Revision:      May-2008
 *
 ***************************************************************************/

using System;
using System.Collections;
using System.Collections.Generic;
using System.Xml;

namespace Latino
{
    /* .-----------------------------------------------------------------------
       |
       |  Interface ICloneable<T>
       |
       '-----------------------------------------------------------------------
    */
    public interface ICloneable<T> : ICloneable
    {
        new T Clone();
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface IDeeplyCloneable
       |
       '-----------------------------------------------------------------------
    */
    public interface IDeeplyCloneable
    {
        object DeeplyClone();
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface IDeeplyCloneable<T>
       |
       '-----------------------------------------------------------------------
    */
    public interface IDeeplyCloneable<T> : IDeeplyCloneable
    {
        new T DeeplyClone();
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface ISerializable
       |
       '-----------------------------------------------------------------------
    */
    public interface ISerializable
    {
        // *** note that you need to implement a constructor that loads the instance if the class implements ISerializable
        void Save(BinarySerializer writer);
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface IXmlSerializable
       |
       '-----------------------------------------------------------------------
    */
    public interface IXmlSerializable
    {
        // *** note that you should implement a constructor that loads the instance if the class implements IXmlSerializable
        void SaveXml(XmlWriter writer);
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface IContentEquatable
       |
       '-----------------------------------------------------------------------
    */
    public interface IContentEquatable
    {
        bool ContentEquals(object other);
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface IContentEquatable<T>
       |
       '-----------------------------------------------------------------------
    */
    public interface IContentEquatable<T> : IContentEquatable
    {
        bool ContentEquals(T other);
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface IBinaryOperator
       |
       '-----------------------------------------------------------------------
    */
    public interface IBinaryOperator
    {
        object PerformOperation(object arg_1, object arg_2);
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface IUnaryOperator
       |
       '-----------------------------------------------------------------------
    */
    public interface IUnaryOperator
    {
        object PerformOperation(object arg);
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface IReadOnlyAdapter
       |
       '-----------------------------------------------------------------------
    */
    public interface IReadOnlyAdapter
    {
        object GetWritableCopy();
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface IReadOnlyAdapter<T>
       |
       '-----------------------------------------------------------------------
    */
    public interface IReadOnlyAdapter<T> : IReadOnlyAdapter
    {
        new T GetWritableCopy();
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface IEnumerableList
       |
       '-----------------------------------------------------------------------
    */
    public interface IEnumerableList : IEnumerable
    {
        object this[int index] { get; }
        int Count { get; }
    }

    /* .-----------------------------------------------------------------------
       |
       |  Interface IEnumerableList<T>
       |
       '-----------------------------------------------------------------------
    */
    public interface IEnumerableList<T> : IEnumerable<T>, IEnumerableList
    {
        new T this[int index] { get; }
    }
}