/*==========================================================================;
 *
 *  (c) 2007-08 JSI.  All rights reserved.
 *
 *  File:          IdxDat2.cs
 *  Version:       1.0
 *  Desc:		   Indexed item data structure (struct)
 *  Author:        Miha Grcar
 *  Created on:    Mar-2007
 *  Last modified: Jul-2008
 *  Revision:      Jul-2008
 *
 ***************************************************************************/

using System;

namespace Latino
{
    /* .-----------------------------------------------------------------------
       |
       |  Struct IdxDat2<T>
       |
       '-----------------------------------------------------------------------
    */
    public struct IdxDat2<T> : IComparable<IdxDat2<T>>, IComparable, IEquatable<IdxDat2<T>>, ISerializable
    {
        private int m_idx;
        private T m_dat;
        public IdxDat2(BinarySerializer reader)
        {
            m_idx = -1;
            m_dat = default(T);
            Load(reader); // throws ArgumentNullException, serialization-related exceptions
        }
        public IdxDat2(int idx, T dat)
        {
            m_idx = idx;
            m_dat = dat;
        }
        public IdxDat2(int idx)
        {
            m_idx = idx;
            m_dat = default(T);
        }
        public int Idx
        {
            get { return m_idx; }
        }
        public T Dat
        {
            get { return m_dat; }
        }
        public override int GetHashCode()
        {
            return m_idx.GetHashCode();
        }
        public override string ToString()
        {
            return string.Format("( {0} {1} )", m_idx, m_dat);
        }
        public static bool operator ==(IdxDat2<T> a, IdxDat2<T> b)
        {
            return a.m_idx == b.m_idx;
        }
        public static bool operator !=(IdxDat2<T> a, IdxDat2<T> b)
        {
            return a.m_idx != b.m_idx;
        }
        public static bool operator >(IdxDat2<T> a, IdxDat2<T> b)
        {
            return a.m_idx > b.m_idx;
        }
        public static bool operator <(IdxDat2<T> a, IdxDat2<T> b)
        {
            return a.m_idx < b.m_idx;
        }
        public static bool operator >=(IdxDat2<T> a, IdxDat2<T> b)
        {
            return a.m_idx >= b.m_idx;
        }
        public static bool operator <=(IdxDat2<T> a, IdxDat2<T> b)
        {
            return a.m_idx <= b.m_idx;
        }
        // *** IComparable<IdxDat2<T>> interface implementation ***
        public int CompareTo(IdxDat2<T> other)
        {
            return m_idx.CompareTo(other.Idx);
        }
        // *** IComparable interface implementation ***
        int IComparable.CompareTo(object obj)
        {
            Utils.ThrowException(!(obj is IdxDat2<T>) ? new ArgumentTypeException("obj") : null);
            return CompareTo((IdxDat2<T>)obj);
        }
        // *** IEquatable<IdxDat2<T>> interface implementation ***
        public bool Equals(IdxDat2<T> other)
        {
            return other.m_idx == m_idx;
        }
        public override bool Equals(object obj)
        {
            Utils.ThrowException(!(obj is IdxDat2<T>) ? new ArgumentTypeException("obj") : null);
            return Equals((IdxDat2<T>)obj);
        }
        // *** ISerializable interface implementation ***
        public void Save(BinarySerializer writer)
        {
            Utils.ThrowException(writer == null ? new ArgumentNullException("writer") : null);
            // the following statements throw serialization-related exceptions
            writer.WriteInt(m_idx); 
            writer.WriteValueOrObject<T>(m_dat); 
        }
        public void Load(BinarySerializer reader)
        {
            Utils.ThrowException(reader == null ? new ArgumentNullException("reader") : null);
            // the following statements throw serialization-related exceptions
            m_idx = reader.ReadInt(); 
            m_dat = reader.ReadValueOrObject<T>(); 
        }
    }
}
