/*==========================================================================;
 *
 *  (c) 2008 JSI.  All rights reserved.
 *
 *  File:          Exceptions.cs
 *  Version:       1.0
 *  Desc:		   Additional exceptions
 *  Author:		   Miha Grcar
 *  Created on:    Feb-2008
 *  Last modified: May-2008
 *  Revision:      May-2008
 *
 ***************************************************************************/

using System;

namespace Latino
{
    /* .-----------------------------------------------------------------------
       |
       |  Class ArgumentTypeException
       |
       '-----------------------------------------------------------------------
    */
    public class ArgumentTypeException : ArgumentException
    {
        public ArgumentTypeException(string param_name) : base("The argument is not of one of the expected types.", param_name)
        {
        }
    }

    /* .-----------------------------------------------------------------------
       |
       |  Class ArgumentNotSupportedException
       |
       '-----------------------------------------------------------------------
    */
    public class ArgumentNotSupportedException : ArgumentException
    {
        public ArgumentNotSupportedException(string param_name) : base("The argument is not supported.", param_name)
        {
        }
    }

    /* .-----------------------------------------------------------------------
       |
       |  Class ArgumentNotFiniteNumberException
       |
       '-----------------------------------------------------------------------
    */
    public class ArgumentNotFiniteNumberException : ArgumentException
    {
        public ArgumentNotFiniteNumberException(string param_name) : base("The argument is not a finite number.", param_name)
        {
        }
    }

    /* .-----------------------------------------------------------------------
       |
       |  Class InvalidArgumentValueException
       |
       '-----------------------------------------------------------------------
    */
    public class InvalidArgumentValueException : ArgumentException
    {
        public InvalidArgumentValueException(string param_name) : base("The argument value or state is not valid.", param_name)
        {
        }
    }

    /* .-----------------------------------------------------------------------
       |
       |  Class XmlFormatException
       |
       '-----------------------------------------------------------------------
    */
    public class XmlFormatException : Exception
    {
        public XmlFormatException() : base("The XML is not in the expected format.")
        {
        }
    }
}
